#pragma once
#include "../DXFramework/DXF.h"

//Base class for some complex meshes, used to encapsulate matrix data
class BowerMesh : public BaseMesh
{
	public:
		BowerMesh();
		~BowerMesh();

		//Position
		void SetPosition(XMFLOAT3 position);
		void SetPosition(float x, float y, float z);

		//Scale
		void SetScale(float scale);
		void SetScale(float scaleX, float scaleY, float scaleZ);

		//Rotation
		void SetRotation(float rot);
		void SetRotation(float rotX, float rotY, float rotZ);

		//Combines the matrices set to produce the final world matrix
		XMMATRIX GetWorldMatrix();

	protected:
		XMMATRIX _WorldMatrix;
		XMMATRIX _ScaleMatrix;
		XMMATRIX _RotationMatrix;
		XMMATRIX _TransformMatrix;
		XMMATRIX _ViewMatrix;
};

